"use client";
import React, { useState } from "react";
import { PostRequest } from "../../../axiosConfig/axiosConfig";
import toast from "react-hot-toast";

const ReplyModal = ({
  isOpen,
  onClose,
  comment,
  videoId,
  commented,
}) => {
  const [replyText, setReplyText] = useState("");
  if (!isOpen) return null;
  const handleSubmit = async (e) => {
    e.preventDefault();
    const parent_id = comment.id;
    const body = replyText;
    const data = {
      parent_id,
      body,
    };
    try {
      const authToken = localStorage.getItem("authToken");
      const res = await PostRequest(
        `/course-videos/${videoId}/comments`,
        data,
        authToken
      );
      toast.success("Reply added successfully!", {
        position: "top-center",
      });
      setReplyText("");
      try {
        commented(true);
      } catch (error) {
        console.error("Failed to fetch comments:", error);
        return;
      }
      onClose();
    } catch (error) {
      console.error("Reply error:", error.message);
      toast.error("Unable to reply to comment", {
        position: "top-right",
      });
    }
  };

  return (
    <div className="fixed inset-0 bg-black bg-opacity-30 flex justify-center items-center z-50">
      <div className="bg-white p-6 rounded-xl w-[400px]">
        <form onSubmit={handleSubmit}>
          <div className="mt-6">
            <p className="font-bold text-xl">Add Reply</p>
            <textarea
              value={replyText}
              onChange={(e) => setReplyText(e.target.value)}
              className=" bg-[#F9F5F5] my-2 w-full p-4 rounded-xl border border-gray-300 focus:outline-none focus:border-golden resize-none"
              rows="4"
              placeholder="Write your reply here..."
            />
          </div>
          <button
            type="submit"
            className="w-full text-center bg-golden py-2 rounded-lg text-white text-sm font-bold"
          >
            Submit
          </button>
        </form>
        <button
          className="mt-4 text-center bg-gray-500 py-2 rounded-lg text-white text-sm font-bold w-full"
          onClick={onClose}
        >
          Close
        </button>
      </div>
    </div>
  );
};

export default ReplyModal;